function y = iwFE(par,parmatch,var);

[a,lambda,jcr,sigma,c,beta,r,b,k,]=expdpar(par);
[R,T,S,v,theta]=expandvar(var);

SIG=sigma*ones(3,1);
wR=zeros(3,1);
wT=zeros(3,1);
wS=zeros(3,1);
wpR=zeros(3,1);
wpT=zeros(3,1);
wpS=zeros(3,1);

for p=1:3;
    x=wage(R(p),par,parmatch,var);
    wR(p)=x(p);
    x=wage(T(p),par,parmatch,var);
    wT(p)=x(p);
    x=wage(S(p),par,parmatch,var);
    wS(p)=x(p);
    x=wprime((R(p)+T(p))/2,par,parmatch,var);
    wpR=x(p);
    x=wprime((T(p)+S(p))/2,par,parmatch,var);
    wpT=x(p);
    x=wprime((S(p)+sigma)/2,par,parmatch,var);
    wpS=x(p);

end;

y = fe1(par,parmatch,var).* [ wR.*(T - R) + wpR.*(T - R).*(T - R)/2 ] + ...
    fe2(par,parmatch,var).* [ wT.*(S - T) + wpT.*(S - T).*(S - T)/2 ] + ...
    fe3(par,parmatch,var).* [ wS.*(SIG - S) + wpS.*(SIG - S).*(SIG - S)/2 ]  ;

